<?php

namespace App\Modules\Ais\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Airport extends Model 
{

    protected $table = 'ais_airport';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id');
    protected $fillable = array('sector_id', 'icao', 'iata', 'name', 'latitude', 'longitude', 'display');

    public function sector()
    {
        return $this->belongsTo('App\Modules\Ais\Models\Fir\Sector');
    }

    public function facilities()
    {
        return $this->hasManyThrough('App\Modules\Ais\Models\Facility', 'App\Modules\Ais\Models\AirportFacility')->withTimestamps();
    }

}